import com.asprise.util.jtwain.Source;
import com.asprise.util.jtwain.SourceManager;

/*
 * $Id$
 * 
 */

public class TestJTwain extends JTwainDemoCode {
	
	public TestJTwain() {
		message("\n\n----------- JTWAIN TEST -----------\n");
		message("Testing results: \n");
		
		message("--- MESG) System Java VM Version: " + System.getProperty("java.vm.version"));
		message("--- MESG) JTWAIN Supports Java 1.2 and above.\n");
		
		//SourceManager.setLibraryPath("E:\\Twain\\Asprise\\JT\\Evaluation\\AspriseJTwain.dll");
		
		
		SourceManager sm;
		
		try {
			sm = SourceManager.instance();
			message("--- MESG) JTWAIN DLL version: " + sm.getJTwainDLLVersion());
		
		}catch(UnsatisfiedLinkError ule) {
			error("*** ERROR) AspriseJTwain.dll does not present on the system path. \n");
			exception(ule);
			return;
		}catch(Exception e) {
			error("*** ERROR) Exception has been thrown:");
			exception(e);
			return;
		}
		
		message("--- OK) Source manager has been successfully loaded. \n");
		
		try {
			Source[] sources = sm.getAllSources();
			for(int i=0; i<sources.length; i++) {
				message("--- OK) Source #" + i + ": " + sources[i] + "\n");
			}
			
			if(sources == null || sources.length == 0) {
				message("--- WARNING) No source presents on the system.");
				message("--- WARNING) Consult Developers' Guide to install a software sample source. \n");
			}
				
		}catch(Exception e){
			error("*** ERROR) Exception has been thrown:");
			exception(e);
			return;
		}
		
		message("----------- END OF TEST -----------\n");
	}
	
	public static void main(String[] args) {

		new TestJTwain();	
	}
}
