/*
 * $Id$
 * $License$
 * Created on 2006-1-5 13:54:45 by Jack Li Guojie
 */
import java.awt.Image;

import com.asprise.util.jtwain.Source;
import com.asprise.util.jtwain.SourceManager;

/**
 * 
 */
public class PartialScanTest extends JTwainDemoCode{
	
	public PartialScanTest() {
		try {
			//SourceManager.setLibraryPath("F:/Twain/Asprise/JT/Evaluation/AspriseJTwain.dll");
			Source source = SourceManager.instance().selectSourceUI();
			source.setMinimumExceptionEnabled(false);
			
			if(source == null) {
				error("There is no selected source!");
				return;
			}
			
			
			message("NOTE:\nPartial scan works with most of scanners. \nHowever, TWAIN Sample Source does not support it.");
			
			source.open();
			
			message("Width: " + source.getPhyscialWidth());
			message("Height: " + source.getPhysicalHeight());
			
			source.setRegion(0, 0, source.getPhyscialWidth()/2, source.getPhysicalHeight()/2);
			
			//source.setXResolution(72);
			//source.setYResolution(72);
			source.setUIEnabled(false);
			Image image = source.acquireImage();
			
			new ImageDisplayer("DemoPartial", image);
			
			message(source.getRegion() + "");
			
			source.close();
			message("DONE.");
			
		}catch(Exception e) {
			exception(e);
		}finally{
			SourceManager.closeSourceManager();
		}
	}


	public static void main(String[] args) {
		new PartialScanTest();
	}
}


