import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class JTwainDemoLauncherFrame extends JFrame {
  JPanel contentPane;
  JMenuBar jMenuBar1 = new JMenuBar();
  JMenu jMenuFile = new JMenu();
  JMenuItem jMenuFileExit = new JMenuItem();
  JMenu jMenuHelp = new JMenu();
  JMenuItem jMenuHelpAbout = new JMenuItem();
  ImageIcon image1;
  ImageIcon image2;
  ImageIcon image3;
  JLabel statusBar = new JLabel();
  BorderLayout borderLayout1 = new BorderLayout();
  JPanel mainPanel = new JPanel();
  BorderLayout borderLayout2 = new BorderLayout();
  JScrollPane jScrollPane1 = new JScrollPane();
  JPanel controlPanel = new JPanel();
  JComboBox classes = new JComboBox();
  JButton launchButton = new JButton();
  JTextArea text = new JTextArea();
  JLabel jLabel1 = new JLabel();
  
  JTwainDemoLauncher launcher;
  
  public JTwainDemoLauncherFrame(JTwainDemoLauncher launcher) {
  	this();
  	this.launcher = launcher;
  }

  //Construct the frame
  public JTwainDemoLauncherFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();

      JTwainDemoCode.OutputListener outputListener;
      outputListener = new JTwainDemoCode.OutputListener();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  //Component initialization
  private void jbInit() throws Exception  {

    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(borderLayout1);
    this.setContentPane(contentPane);
    this.setDefaultCloseOperation(EXIT_ON_CLOSE);
    this.setSize(new Dimension(500, 600));
    this.setTitle("JTwain Demos - Select a demo and click the launch button ...");
    statusBar.setText(" ");
    jMenuFile.setText("File");
    jMenuFileExit.setText("Exit");
    jMenuFileExit.addActionListener(new JTwainDemoLauncherFrame_jMenuFileExit_ActionAdapter(this));
    jMenuHelp.setText("Help");
    jMenuHelpAbout.setText("About");
    jMenuHelpAbout.addActionListener(new JTwainDemoLauncherFrame_jMenuHelpAbout_ActionAdapter(this));
    mainPanel.setLayout(borderLayout2);
    launchButton.setText("Launch!");
    launchButton.addActionListener(new JTwainDemoLauncherFrame_launchButton_actionAdapter(this));
    jLabel1.setText("Demos: ");
    contentPane.setMinimumSize(new Dimension(400, 600));
    contentPane.setPreferredSize(new Dimension(400, 600));
    jMenuFile.add(jMenuFileExit);
    jMenuHelp.add(jMenuHelpAbout);
    jMenuBar1.add(jMenuFile);
    jMenuBar1.add(jMenuHelp);
    this.setJMenuBar(jMenuBar1);
    contentPane.add(statusBar, BorderLayout.SOUTH);
    contentPane.add(mainPanel,  BorderLayout.CENTER);
    mainPanel.add(jScrollPane1,  BorderLayout.CENTER);
    jScrollPane1.getViewport().add(text, null);
    mainPanel.add(controlPanel, BorderLayout.NORTH);
    controlPanel.add(jLabel1, null);
    controlPanel.add(classes, null);
    controlPanel.add(launchButton, null);
  }

  //File | Exit action performed
  public void jMenuFileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }

  //Help | About action performed
  public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
    JTwainDemoLauncherFrame_AboutBox dlg = new JTwainDemoLauncherFrame_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.pack();
    dlg.show();
  }

  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      jMenuFileExit_actionPerformed(null);
    }
  }

  void launchButton_actionPerformed(ActionEvent e) {
	launcher.invokeClass(classes.getSelectedItem().toString());
  }
}

class JTwainDemoLauncherFrame_jMenuFileExit_ActionAdapter implements ActionListener {
  JTwainDemoLauncherFrame adaptee;

  JTwainDemoLauncherFrame_jMenuFileExit_ActionAdapter(JTwainDemoLauncherFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuFileExit_actionPerformed(e);
  }
}

class JTwainDemoLauncherFrame_jMenuHelpAbout_ActionAdapter implements ActionListener {
  JTwainDemoLauncherFrame adaptee;

  JTwainDemoLauncherFrame_jMenuHelpAbout_ActionAdapter(JTwainDemoLauncherFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuHelpAbout_actionPerformed(e);
  }
}

class JTwainDemoLauncherFrame_launchButton_actionAdapter implements java.awt.event.ActionListener {
  JTwainDemoLauncherFrame adaptee;

  JTwainDemoLauncherFrame_launchButton_actionAdapter(JTwainDemoLauncherFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.launchButton_actionPerformed(e);
  }
}
