import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import javax.swing.UIManager;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class JTwainDemoLauncher {
	boolean packFrame = false;

	JTwainDemoLauncherFrame frame;
	
	String demoJar;

	//Construct the application
	public JTwainDemoLauncher(String demoJar) {
		this.demoJar = demoJar;
		frame = new JTwainDemoLauncherFrame(this);
		//Validate frames that have preset sizes
		//Pack frames that have useful preferred size info, e.g. from their layout
		if (packFrame) {
			frame.pack();
		} else {
			frame.validate();
		}
		//Center the window
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension frameSize = frame.getSize();
		if (frameSize.height > screenSize.height) {
			frameSize.height = screenSize.height;
		}
		if (frameSize.width > screenSize.width) {
			frameSize.width = screenSize.width;
		}
		frame.setLocation(
			(screenSize.width - frameSize.width) / 2,
			(screenSize.height - frameSize.height) / 2);
		frame.setVisible(true);
		frame.jMenuHelpAbout_actionPerformed(null);

		loadClasses(demoJar);
	}

	/**
	 * Loads class names from the demo package. 
	 *
	 */
	public void loadClasses(String fileName) {
		File file = null;

		try {
			file = new File(fileName);
			if (!file.exists()) {
				messageListener.error("The Jar file specified does not exist: " + file.toString());
			}
		} catch (Exception e) {
			messageListener.exception(e);
		}

		if (file == null) {
			loadClasses((JarFile)null);
		} else {
			try {
				loadClasses(new JarFile(file));
			} catch (IOException e1) {
				messageListener.exception(e1);
			}
		}

	}

	class MessageListener extends JTwainDemoCode.OutputListener {
		StringWriter stringWriter = new StringWriter();
		PrintWriter printWriter = new PrintWriter(stringWriter);
		
		public void error(String error) {
			frame.text.append(error + "\n");
		}

		public void exception(Throwable e) {
			stringWriter.getBuffer().setLength(0);
			e.printStackTrace(printWriter);
			printWriter.flush();
			stringWriter.flush();
			frame.text.append(stringWriter.getBuffer().toString() + "\n");
			
		}

		/* (non-Javadoc)
		 * @see JTwainDemoCode.OutputListener#message(java.lang.String)
		 */
		public void message(String message) {
			frame.text.append(message + "\n");
		}
	}
	
	MessageListener messageListener = new MessageListener();

	public void loadClasses(JarFile jarFile) {
		JTwainDemoCode.setOutputListener(messageListener);
		
		if (jarFile == null) {
			frame.text.append("Jar file not found!");
			return;
		}

		for (Enumeration enumeration = jarFile.entries();
			enumeration.hasMoreElements();
			) {
			JarEntry entry = (JarEntry) enumeration.nextElement();
			String name = entry.getName();
			if (name.endsWith(".class")) {
				name = name.substring(0, name.length() - 6);

				// Check type.
				try {
					Class cls = Class.forName(name);
					if (cls.getSuperclass().equals(JTwainDemoCode.class)) {
						// ok 
						frame.classes.addItem(name);
					}

				} catch (Throwable t) {
					messageListener.exception(t);
				}

			} else {
				continue;
			}
		}
		
		frame.classes.setSelectedItem("TestJTwain");

	}
	
	public void invokeClass(String className) {
		frame.text.setText("Executing " + className + " ... \n");
		try {
			invokeMainMethod(className, null);
		}catch(Throwable t) {
			messageListener.exception(t);
		}
	}

	//Main method
	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(args != null && args.length >= 1)
			new JTwainDemoLauncher(args[0]);
		else
			new JTwainDemoLauncher(null);
	}



	/**
	 * Invokes the <code>public static void main(String[])</code> method of 
	 * the target class. 
	 * @param targetClass
	 * @param arguments
	 * @throws ClassNotFoundException
	 */
	public static void invokeMainMethod(String targetClass, String[] arguments) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
		Class[] paramTypes = new Class[] {Class.forName("[Ljava.lang.String;")};
		
		Method main = Class.forName(targetClass).getMethod("main", paramTypes);
	
		// Verification. 
		if((main.getModifiers() & Modifier.STATIC) == 0) {
			throw new NoSuchMethodException("The main method in target class is not static.");
		}
		if(main.getReturnType() != void.class) {
			throw new NoSuchMethodException("The return type of the main method in target class is not void.");
		}
	
		main.invoke(null, new Object[]{arguments});
	}
}
