import java.awt.FileDialog;
import java.awt.Image;
import java.io.File;

import com.asprise.util.jtwain.Source;
import com.asprise.util.jtwain.SourceManager;

/*
 * $Id$
 * 
 */

public class DemoSaveJPEG extends JTwainDemoCode{
	
	public DemoSaveJPEG() {
		
		try {
			//SourceManager.setLibraryPath("E:\\Twain\\Asprise\\JT\\Debug\\JT.dll");
			Source source = SourceManager.instance().getDefaultSource();
			
			if(source == null) {
				error("There is no (default) source on the system!");
				return;
			}
			
			source.open();
			
			Image image = source.acquireImage();
			
			ImageDisplayer imageDisplayer = new ImageDisplayer("DemoSimple", image);
			
			FileDialog fileDialog = new FileDialog(imageDisplayer.getFrame(), "Save the image acquired into a file: ", FileDialog.SAVE);
			fileDialog.show();
			
			source.saveLastAcquiredImageIntoFile(new File(fileDialog.getDirectory(), fileDialog.getFile()));

			source.close();
			
		}catch(Exception e) {
			exception(e);
		}finally{
			SourceManager.closeSourceManager();
		}
	}

	public static void main(String[] args) {
		new DemoSaveJPEG();
	}
}
