import com.asprise.util.jtwain.Source;
import com.asprise.util.jtwain.SourceManager;

/*
 * $Id$
 * 
 */

public class DemoGetCapabilities extends JTwainDemoCode{
	public DemoGetCapabilities()  {
		
		try {
			Source source = SourceManager.instance().selectSourceUI();
			
			if(source == null) {
				error("No source selected!");
				return;
			}		
			
			source.open();
			
			String caps[] = source.getSupportedCapabilitiesStrings();
			
			message(source.toString(true));
			message("supports the following capabilities: \n");
			
			for(int i=0; caps != null && i< caps.length; i++) 
				message(caps[i]);
			
		}catch(Exception e) {
			exception(e);
		}finally{
			SourceManager.closeSourceManager();
		}
	}
	
	public static void main(String[] args) {
		new DemoGetCapabilities();
	}
	
	public static String printArray(double[] ints) {
		StringBuffer sb = new StringBuffer();
		sb.append("double[]: ");
		for(int i=0; i<ints.length; i++)
			if(i != ints.length-1)
				sb.append(ints[i] + ", ");
			else
				sb.append(ints[i]);
		
		return sb.toString();
	}
	
	public static String printArray(int[] ints) {
		StringBuffer sb = new StringBuffer();
		sb.append("int[]: ");
		for(int i=0; i<ints.length; i++)
			if(i != ints.length-1)
				sb.append(ints[i] + ", ");
			else
				sb.append(ints[i]);
		
		return sb.toString();
	}
}
