import java.awt.Image;

import com.asprise.util.jtwain.JTwainConstants;
import com.asprise.util.jtwain.Source;
import com.asprise.util.jtwain.SourceManager;

/*
 * $Id$
 * $License$
 * Created on 2006-1-5 9:13:57 by Jack Li Guojie
 */

/**
 * 
 */
public class DemoFrame extends JTwainDemoCode {

	public DemoFrame() {
		try {
			Source source = SourceManager.instance().selectSourceUI();

			if (source == null) {
				error("There is no (default) source on the system!");
				return;
			}

			source.open();
			
			source.setMinimumExceptionEnabled(false);
			
			source.setUnits(JTwainConstants.TWUN_INCHES);
		
			//source.setXResolution(100);
			//source.setYResolution(100);
			source.setTransferCount(1);
			System.out.println("XF counter: " + source.getTransferCount());
			
			System.out.println("Max frames: " + source.getMaxFrames());
			System.out.println(printFrames(source.getFrames()));
			//source.setFrames(new double[]{10, 20, 100, 200});
		
			double[] frame = source.getFrames()[0];
			frame[3] /= 1.2;
			System.out.println("Try: " + printFrames(new double[][]{frame}));
			source.setFrames(frame);
			
			System.out.println("--- AFTER setFrames ---");
			System.out.println("Max frames: " + source.getMaxFrames());
			System.out.println(printFrames(source.getFrames()));

			Image image = source.acquireImage();

			new ImageDisplayer("DemoFrame", image);

			source.close();

		} catch (Exception e) {
			e.printStackTrace();
			exception(e);
		} finally {
			SourceManager.closeSourceManager();
		}
	}
	
	public static String printFrames(double[][] frames) {
		if(frames == null)
			return "!NULL!";
		
		StringBuffer sb = new StringBuffer("FRAMES (size: " + frames.length + ")");
		for(int i=0; i<frames.length; i++) {
			sb.append("\n[");
			for(int j=0; frames[i] != null && j < frames[i].length; j++) {
				sb.append(" ");
				sb.append(frames[i][j]);
				sb.append(" ");
			}
			sb.append("]");
		}
		return sb.toString();
	}

	public static void main(String[] args) {
		new DemoFrame();
	}
	

}