import java.awt.Image;

import com.asprise.util.jtwain.JTwainConstants;
import com.asprise.util.jtwain.Source;
import com.asprise.util.jtwain.SourceManager;
import com.asprise.util.jtwain.lowlevel.ItemTypeInteger;
import com.asprise.util.jtwain.lowlevel.ValueContainerOneValue;

/*
 * $Id$
 * 
 */

public class DemoADF extends JTwainDemoCode {
	public DemoADF()  {
		try {
			Source source = SourceManager.instance().selectSourceUI();
			source.open();
			source.setMinimumExceptionEnabled(false);
			
			/** Uncomments the following code to see ADF without UI.
			 */
			
			try {
				System.out.println("Is CAP_DUPLEX supported? " + source.getCapability(JTwainConstants.MSG_GET, JTwainConstants.CAP_DUPLEXENABLED, JTwainConstants.TWON_ONEVALUE));
				// sets CAP_DUPLEXENABLED
				source.setCapability(JTwainConstants.CAP_DUPLEXENABLED, new ValueContainerOneValue(new ItemTypeInteger(JTwainConstants.TWTY_BOOL, 1)));
			} catch (Exception e1) {
				error("CAP_DUPLEX Unsupported: " + e1);
				error("ADF may not work");
			}
						
			source.setUIEnabled(true);
			source.setFeederEnabled(true);
			
			try {
				source.setAutoFeed(true);
			} catch (Exception e2) {
				error("Can not set auto feed: " + e2);
				error("ADF may not work");
			}
			
			source.setTransferCount(4);
			
			
			int counter = 0;
			
			do {
				Image image = source.acquireImage();
				new ImageDisplayer("DemoADF - Image #" + counter, image);
				counter ++;
			}while(source.hasMoreImages());
			
			
		}catch(Exception e) {
			e.printStackTrace();
			exception(e);
		}finally{
			SourceManager.closeSourceManager();
		}
	}
	
	public static void main(String[] args) {
		new DemoADF();
	}
}
