/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.jtwain.lowlevel;

import com.asprise.util.jtwain.lowlevel.ItemType;
import com.asprise.util.jtwain.lowlevel.ItemTypeFix32;
import com.asprise.util.jtwain.lowlevel.ItemTypeFrame;
import com.asprise.util.jtwain.lowlevel.ItemTypeInteger;
import com.asprise.util.jtwain.lowlevel.ItemTypeString;
import com.asprise.util.jtwain.lowlevel.ValueContainer;

public class ValueContainerRange
extends ValueContainer {
    ItemType minValue;
    ItemType maxValue;
    ItemType stepSize;
    ItemType defaultValue;
    ItemType currentValue;

    private void checkConsistency() {
        int baseCode = -1;
        baseCode = this.checkConsistency(this.minValue, baseCode);
        baseCode = this.checkConsistency(this.maxValue, baseCode);
        baseCode = this.checkConsistency(this.stepSize, baseCode);
        baseCode = this.checkConsistency(this.defaultValue, baseCode);
        baseCode = this.checkConsistency(this.currentValue, baseCode);
    }

    private int checkConsistency(ItemType item, int baseCode) {
        if (item != null) {
            if (baseCode != -1 && baseCode != item.getItemTypeCode()) {
                throw new IllegalArgumentException("Value type inconsistent!");
            }
            return item.getItemTypeCode();
        }
        return -1;
    }

    public ItemType getCurrentValue() {
        return this.currentValue;
    }

    public ItemType getDefaultValue() {
        return this.defaultValue;
    }

    public ItemType getMaxValue() {
        return this.maxValue;
    }

    public ItemType getMinValue() {
        return this.minValue;
    }

    public ItemType getStepSize() {
        return this.stepSize;
    }

    public ItemType getItem(int index) {
        switch (index) {
            case 0: {
                return this.getMinValue();
            }
            case 1: {
                return this.getMaxValue();
            }
            case 2: {
                return this.getStepSize();
            }
            case 3: {
                return this.getDefaultValue();
            }
            case 4: {
                return this.getCurrentValue();
            }
        }
        return null;
    }

    public void setCurrentValue(ItemType type) {
        this.checkConsistency();
        this.currentValue = type;
        this.setItemType(type.getItemTypeCode());
    }

    public void setDefaultValue(ItemType type) {
        this.checkConsistency();
        this.defaultValue = type;
        this.setItemType(type.getItemTypeCode());
    }

    public void setMaxValue(ItemType type) {
        this.checkConsistency();
        this.maxValue = type;
        this.setItemType(type.getItemTypeCode());
    }

    public void setMinValue(ItemType type) {
        this.checkConsistency();
        this.minValue = type;
        this.setItemType(type.getItemTypeCode());
    }

    public void setStepSize(ItemType type) {
        this.checkConsistency();
        this.stepSize = type;
        this.setItemType(type.getItemTypeCode());
    }

    public int getContainerType() {
        return 6;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ValueContainerRange [" + ItemType.getTypeRepresentation(this.getItemType()) + "]\n");
        sb.append(" - min:\t" + this.getMinValue() + "\n");
        sb.append(" - max:\t" + this.getMaxValue() + "\n");
        sb.append(" - step:\t" + this.getStepSize() + "\n");
        sb.append(" - default:\t" + this.getDefaultValue() + "\n");
        sb.append(" - current:\t" + this.getCurrentValue() + "\n");
        return sb.toString();
    }

    public Object getObject() {
        if (this.getCurrentValue() == null) {
            return null;
        }
        ItemType item = this.getCurrentValue();
        if (item instanceof ItemTypeFix32) {
            ItemTypeFix32 min = (ItemTypeFix32)this.getMinValue();
            ItemTypeFix32 max = (ItemTypeFix32)this.getMaxValue();
            ItemTypeFix32 step = (ItemTypeFix32)this.getStepSize();
            int size = (int)Math.ceil((max.getValue() - min.getValue()) / step.getValue()) + 1;
            Double[] doubles = new Double[size];
            int i = 0;
            while (i < doubles.length - 1) {
                doubles[i] = new Double(min.getValue() + (double)i * step.getValue());
                ++i;
            }
            doubles[doubles.length - 1] = new Double(max.getValue());
            return doubles;
        }
        if (item instanceof ItemTypeInteger) {
            ItemTypeInteger min = (ItemTypeInteger)this.getMinValue();
            ItemTypeInteger max = (ItemTypeInteger)this.getMaxValue();
            ItemTypeInteger step = (ItemTypeInteger)this.getStepSize();
            int size = (int)Math.ceil(1.0 * (double)(max.getValue() - min.getValue()) / (double)step.getValue()) + 1;
            Long[] integers = new Long[size];
            int i = 0;
            while (i < size - 1) {
                integers[i] = new Long(min.getValue() + (long)i * step.getValue());
                ++i;
            }
            integers[size - 1] = new Long(max.getValue());
            return integers;
        }
        if (item instanceof ItemTypeString) {
            return null;
        }
        if (item instanceof ItemTypeFrame) {
            return null;
        }
        return null;
    }
}

