/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.jtwain.lowlevel;

import com.asprise.util.jtwain.JTwainConstants;
import com.asprise.util.jtwain.lowlevel.ValueContainer;

public class OperationResult
implements JTwainConstants {
    private int returnCode = -1;
    private int conditionCode = -1;
    private ValueContainer container;
    public Object layoutImage;

    public OperationResult(int returnCode, int conditionCode, ValueContainer container) {
        this.returnCode = returnCode;
        this.conditionCode = conditionCode;
        this.container = container;
    }

    public OperationResult(int returnCode, int conditionCode) {
        this.returnCode = returnCode;
        this.conditionCode = conditionCode;
    }

    public int getConditionCode() {
        return this.conditionCode;
    }

    public ValueContainer getContainer() {
        return this.container;
    }

    public void setContainer(ValueContainer container) {
        this.container = container;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getReturnCode() >= 0) {
            sb.append("<Return code> " + OperationResult.getReturnCodeRepresentation(this.getReturnCode()) + "\t");
        }
        if (this.getConditionCode() >= 0) {
            sb.append("<Condition code> " + OperationResult.getConditionCodeRepresentation(this.getConditionCode()) + "\n");
        }
        if (this.container != null) {
            sb.append("<Container> " + this.getContainer());
        }
        return sb.toString();
    }

    public static String getReturnCodeRepresentation(int code) {
        switch (code) {
            case 3: {
                return "Cancel";
            }
            case 2: {
                return "Check Status";
            }
            case 32768: {
                return "Custom Base";
            }
            case 9: {
                return "Data Not Avaliable";
            }
            case 4: {
                return "DS Event";
            }
            case 7: {
                return "End of List";
            }
            case 1: {
                return "Failure";
            }
            case 8: {
                return "Info Not Supported";
            }
            case 5: {
                return "Not DS Event";
            }
            case 0: {
                return "Success";
            }
            case 6: {
                return "XFERDONE";
            }
        }
        return "Unknown";
    }

    public static String getConditionCodeRepresentation(int code) {
        switch (code) {
            case 6: {
                return "Bad Cap";
            }
            case 12: {
                return "Bad Dest";
            }
            case 9: {
                return "Bad Protocol";
            }
            case 10: {
                return "Bad Value";
            }
            case 1: {
                return "Bummer";
            }
            case 14: {
                return "Bad Capability Operation";
            }
            case 15: {
                return "Capability Sequence Error";
            }
            case 13: {
                return "Capability Unsupported";
            }
            case 23: {
                return "Check Device Online";
            }
            case 32768: {
                return "Custom Base";
            }
            case 16: {
                return "Denied";
            }
            case 17: {
                return "File Exists";
            }
            case 18: {
                return "File Not Found";
            }
            case 22: {
                return "File Writer Error";
            }
            case 2: {
                return "Low Memory";
            }
            case 4: {
                return "Max Connections";
            }
            case 3: {
                return "No Data Source";
            }
            case 19: {
                return "Not Empty";
            }
            case 5: {
                return "Operation Error";
            }
            case 21: {
                return "Paper Double Feed";
            }
            case 20: {
                return "Paper Jam";
            }
            case 11: {
                return "Sequence Error";
            }
            case 0: {
                return "Success";
            }
        }
        return "Unknown";
    }

    public boolean isSuccessful() {
        return this.conditionCode == 0 && this.returnCode == 0;
    }

    public Object getLayoutImage() {
        return this.layoutImage;
    }

    public void setLayoutImage(Object layoutImage) {
        this.layoutImage = layoutImage;
    }
}

