/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.jtwain.lowlevel;

import com.asprise.util.jtwain.JTwainConstants;
import com.asprise.util.jtwain.lowlevel.ItemType;

public class ItemTypeInteger
extends ItemType
implements JTwainConstants {
    private long value;

    public ItemTypeInteger(int type) {
        this(type, 0L);
    }

    public ItemTypeInteger(int type, long value) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.setItemTypeCode(type);
                this.setValue(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("This type is not supported by ItemTypeInteger!");
            }
        }
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        switch (this.getItemTypeCode()) {
            case 6: {
                if (value == 0L || value == 1L) break;
                throw new IllegalArgumentException("Type TWTY_BOOL shoule be either 0 or 1. Your input is: " + value);
            }
            case 0: {
                if (value >= -128L && value <= 127L) break;
                throw new IllegalArgumentException("Type TWTY_INT8 value range is [-128, 127]. Your input is: " + value);
            }
            case 1: {
                if (value >= -32768L && value <= 32767L) break;
                throw new IllegalArgumentException("Type TWTY_INT16 value range is [-32768, 32767]. Your input is: " + value);
            }
            case 2: {
                if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) break;
                throw new IllegalArgumentException("Type TWTY_INT32 value range is [-2147483648, 2147483647]. Your input is: " + value);
            }
            case 3: {
                if (value >= 0L && value <= 255L) break;
                throw new IllegalArgumentException("Type TWTY_UINT8 value range is [0, 255]. Your input is: " + value);
            }
            case 4: {
                if (value >= 0L && value <= 65535L) break;
                throw new IllegalArgumentException("Type TWTY_UINT16 value range is [0, 65535]. Your input is: " + value);
            }
            case 5: {
                if (value >= 0L && value <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("Type TWTY_UINT32 value range is [0, 4294967295]. Your input is: " + value);
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + this.getItemTypeCode());
            }
        }
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value) + "\t[" + ItemType.getTypeRepresentation(this.getItemTypeCode()) + "]";
    }

    public Object getObject() {
        return new Long(this.getValue());
    }
}

