/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.jtwain;

import com.asprise.util.jtwain.ImageGenerator;
import com.asprise.util.jtwain.InvalidStateException;
import com.asprise.util.jtwain.JTwainConstants;
import com.asprise.util.jtwain.JTwainException;
import com.asprise.util.jtwain.OperationException;
import com.asprise.util.jtwain.SourceManager;
import com.asprise.util.jtwain.lowlevel.Capability;
import com.asprise.util.jtwain.lowlevel.Control;
import com.asprise.util.jtwain.lowlevel.DataTypeIdentity;
import com.asprise.util.jtwain.lowlevel.DataTypeImageLayout;
import com.asprise.util.jtwain.lowlevel.ItemTypeFix32;
import com.asprise.util.jtwain.lowlevel.ItemTypeFrame;
import com.asprise.util.jtwain.lowlevel.ItemTypeInteger;
import com.asprise.util.jtwain.lowlevel.ItemTypeString;
import com.asprise.util.jtwain.lowlevel.OperationResult;
import com.asprise.util.jtwain.lowlevel.ValueContainer;
import com.asprise.util.jtwain.lowlevel.ValueContainerArray;
import com.asprise.util.jtwain.lowlevel.ValueContainerOneValue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Source
implements JTwainConstants {
    public static final int INVALID_NUMBER = -999;
    public static final int EXCEPTION_THROW_ALL = 2;
    public static final int EXCEPTION_THROW_SOME = 1;
    public static final int EXCEPTION_THROW_MINIMUM = 0;
    private int exceptionLevel = 0;
    private String sourceName;
    private DataTypeIdentity identity;
    private boolean enableUI = true;
    private Image currentImage = null;

    public Source(String sourceName) {
        this.sourceName = sourceName;
    }

    public Source(DataTypeIdentity identity) {
        this.identity = identity;
    }

    public String getSourceName() {
        if (this.sourceName != null) {
            return this.sourceName;
        }
        if (this.identity != null) {
            return this.identity.getProductName();
        }
        return null;
    }

    public DataTypeIdentity getIdentity() {
        return this.identity;
    }

    public boolean isUIEnabled() {
        return this.enableUI;
    }

    public void setUIEnabled(boolean enableUI) {
        this.enableUI = enableUI;
    }

    public void open() throws JTwainException {
        SourceManager.instance().openSource(this);
    }

    public int getState() throws JTwainException {
        return Control.getState(this);
    }

    public int getNumberOfPendingImages() throws JTwainException {
        Control.assertStateAtLeast(this, 4);
        int num = Control.getNumberOfPendingImages();
        if (num == -1 && this.exceptionLevel > 0) {
            throw new JTwainException("Failed to determine number of pending images");
        }
        return num;
    }

    public boolean hasMoreImages() throws JTwainException {
        int num = this.getNumberOfPendingImages();
        return num == -1 || num > 0;
    }

    public void close() throws JTwainException {
        SourceManager.instance().closeSource();
    }

    public BufferedImage acquireImageAsBufferedImage() throws JTwainException {
        Image img = this.acquireImage();
        if (img == null) {
            return null;
        }
        return ImageGenerator.createBufferedImage(img);
    }

    public Image acquireImage() throws JTwainException {
        this.currentImage = null;
        String filePath = Control.acquireOneImage(this);
        if (filePath == null) {
            throw new JTwainException("Failed to acquire image");
        }
        try {
            this.currentImage = Toolkit.getDefaultToolkit().getImage(filePath);
            return this.currentImage;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.currentImage = null;
            throw new JTwainException("Failed to acquire image");
        }
    }

    public Image getLastAcquiredImage() {
        return this.currentImage;
    }

    public InputStream outputLastAcquiredImageAsJPEG() throws IOException {
        String path = Control.getLastScannedFile();
        if (path == null || path.trim().length() == 0) {
            throw new IOException("Failed to retrieve last acquired image.");
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("Failed to retrieve last acquired image.");
        }
        if (!file.canRead()) {
            throw new IOException("Failed to retrieve last acquired image.");
        }
        return new FileInputStream(file);
    }

    public File saveLastAcquiredImageIntoTemporaryFile() throws IOException {
        String path = Control.getLastScannedFile();
        if (path == null || path.trim().length() == 0) {
            throw new IOException("Failed to retrieve last acquired image.");
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("Failed to retrieve last acquired image.");
        }
        if (!file.canRead()) {
            throw new IOException("Failed to retrieve last acquired image.");
        }
        return file;
    }

    public void saveLastAcquiredImageIntoFile(String destination) throws IOException {
        this.saveLastAcquiredImageIntoFile(new File(destination));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveLastAcquiredImageIntoFile(File destination) throws IOException {
        String path = Control.getLastScannedFile();
        if (path == null) throw new IOException("Failed to retrieve last acquired image.");
        if (path.trim().length() == 0) {
            throw new IOException("Failed to retrieve last acquired image.");
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("Failed to retrieve last acquired image.");
        }
        if (!file.canRead()) {
            throw new IOException("Failed to retrieve last acquired image.");
        }
        FileInputStream inputStream = new FileInputStream(file);
        FileOutputStream outputStream = new FileOutputStream(destination);
        try {
            int byteRead;
            byte[] buffer = new byte[2048];
            while ((byteRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, byteRead);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            inputStream.close();
            outputStream.close();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        inputStream.close();
        outputStream.close();
    }

    public void setMinimumExceptionEnabled(boolean enableMinimumException) {
        this.exceptionLevel = enableMinimumException ? 0 : 2;
    }

    public boolean getMinimumExceptionEnabled() {
        return this.exceptionLevel == 0;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        if (verbose) {
            return "Source: " + (this.identity == null ? this.sourceName : this.identity.toString());
        }
        return "Source: " + (this.identity == null ? this.sourceName : this.identity.getProductName());
    }

    public void setRegion(double left, double top, double right, double bottom) throws OperationException {
        DataTypeImageLayout layoutset = new DataTypeImageLayout(new ItemTypeFrame(left, top, right, bottom), 1, 1, 1);
        OperationResult res = Control.ImageLayoutSet(layoutset);
        if (res == null && this.exceptionLevel > 0) {
            throw new OperationException("Operation failed.");
        }
        if (!res.isSuccessful() && this.exceptionLevel > 0) {
            throw new OperationException("Operation failed: " + res);
        }
    }

    public DataTypeImageLayout getRegion() throws OperationException {
        OperationResult res = Control.ImageLayoutGet();
        if (res == null && this.exceptionLevel > 0) {
            throw new OperationException("Operation failed.");
        }
        if (!res.isSuccessful() && this.exceptionLevel > 0) {
            throw new OperationException("Operation failed: " + res);
        }
        return (DataTypeImageLayout)res.getLayoutImage();
    }

    public int getTransferCount() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(1, 1, 5));
    }

    public int getCurrentTransferCount() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(2, 1, 5));
    }

    public int getDefaultTransferCount() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(3, 1, 5));
    }

    public int resetTransferCount() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(7, 1, 5));
    }

    public void setTransferCount(int count) throws InvalidStateException, OperationException {
        this.setCapability(1, new ValueContainerOneValue(new ItemTypeInteger(1, count)));
    }

    public int[] getSupportedCapabilities() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 4101, 3));
    }

    public String[] getSupportedCapabilitiesStrings() throws InvalidStateException, OperationException {
        Long[] values = null;
        try {
            values = (Long[])this.getCapability(1, 4101, 3);
        }
        catch (OperationException oe) {
            values = (Long[])this.getCapability(1, 4101, 4);
        }
        if (values == null) {
            return null;
        }
        String[] strings = new String[values.length];
        int i = 0;
        while (i < strings.length) {
            strings[i] = Capability.getCapabilityString(values[i].intValue());
            ++i;
        }
        return strings;
    }

    public boolean getUIControllable() throws InvalidStateException, OperationException {
        Long value = (Long)this.getCapability(1, 4110, 5);
        return value == null ? false : value.intValue() == 1;
    }

    public int[] getCompression() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 256, 65535));
    }

    public int getCurrentCompression() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(2, 256, 5));
    }

    public int getDefaultCompression() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(3, 256, 65535));
    }

    public void setCompression(int compression) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(2, compression));
        this.setCapability(256, container);
    }

    public int[] getPlanarChunky() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 4384, 65535));
    }

    public int getCurrentPlanarChunky() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(2, 4384, 5));
    }

    public int getDefaultPlanarChunky() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(3, 4384, 65535));
    }

    public double getPhysicalHeight() throws InvalidStateException, OperationException {
        Double value = (Double)this.getCapability(1, 4370, 5);
        if (value == null) {
            return -999.0;
        }
        return value;
    }

    public double getCurrentPhysicalHeight() throws InvalidStateException, OperationException {
        Double value = (Double)this.getCapability(2, 4370, 5);
        if (value == null) {
            return -999.0;
        }
        return value;
    }

    public double getDefaultPhysicalHeight() throws InvalidStateException, OperationException {
        Double value = (Double)this.getCapability(3, 4370, 5);
        if (value == null) {
            return -999.0;
        }
        return value;
    }

    public double getPhyscialWidth() throws InvalidStateException, OperationException {
        Double value = (Double)this.getCapability(1, 4369, 5);
        if (value == null) {
            return -999.0;
        }
        return value;
    }

    public double getCurrentPhyscialWidth() throws InvalidStateException, OperationException {
        Double value = (Double)this.getCapability(2, 4369, 5);
        if (value == null) {
            return -999.0;
        }
        return value;
    }

    public double getDefaultPhyscialWidth() throws InvalidStateException, OperationException {
        Double value = (Double)this.getCapability(3, 4369, 5);
        if (value == null) {
            return -999.0;
        }
        return value;
    }

    public int[] getPixelFlavor() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 4383, 65535));
    }

    public int getCurrentPixelFlavor() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(2, 4383, 5));
    }

    public int getDefaulttPixelFlavor() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(3, 4383, 5));
    }

    public int[] getBitDepth() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 4395, 65535));
    }

    public int getCurrentBitDepth() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(2, 4395, 5));
    }

    public int getDefaultBitDepth() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(3, 4395, 5));
    }

    public void resetBitDepth() throws InvalidStateException, OperationException {
        this.resetCapability(4395);
    }

    public void setBitDepth(int bitDepth) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(4, bitDepth));
        this.setCapability(4395, container);
    }

    public int[] getBitOrder() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 4380, 65535));
    }

    public int getCurrentBitOrder() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(2, 4380, 5));
    }

    public int getDefaultBitOrder() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(3, 4380, 5));
    }

    public void resetBitOrder() throws InvalidStateException, OperationException {
        this.resetCapability(4380);
    }

    public void setBitOrder(int bitOrder) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(4, bitOrder));
        this.setCapability(4380, container);
    }

    public int[] getPixelType() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 257, 65535));
    }

    public int getCurrentPixelType() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(2, 257, 5));
    }

    public int getDefaultPixelType() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(3, 257, 5));
    }

    public void resetPixelType() throws InvalidStateException, OperationException {
        this.resetCapability(257);
    }

    public void setPixelType(int pixelType) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(4, pixelType));
        this.setCapability(257, container);
    }

    public int[] getUnits() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 258, 65535));
    }

    public int[] getCurrentUnits() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(2, 258, 65535));
    }

    public int[] getDefaultUnits() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(3, 258, 65535));
    }

    public void resetUnits() throws InvalidStateException, OperationException {
        this.resetCapability(258);
    }

    public void setUnits(int unitCode) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(4, unitCode));
        this.setCapability(258, container);
    }

    public int[] getTransferMechanism() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 259, 65535));
    }

    public int getCurrentTransferMechanism() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(2, 259, 5));
    }

    public int getDefaultTransferMechanism() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(3, 259, 5));
    }

    public void resetTransferMechanism() throws InvalidStateException, OperationException {
        this.resetCapability(259);
    }

    public void setTransferMechanims(int transferMechanism) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(4, transferMechanism));
        this.setCapability(259, container);
    }

    public double[] getXResolution() throws InvalidStateException, OperationException {
        return Source.getDoubleArray(this.getCapability(1, 4376, 65535));
    }

    public double getCurrentXResolution() throws InvalidStateException, OperationException {
        return Source.getDouble(this.getCapability(2, 4376, 5));
    }

    public double getDefaultXResolution() throws InvalidStateException, OperationException {
        return Source.getDouble(this.getCapability(3, 4376, 5));
    }

    public void resetXResolution() throws InvalidStateException, OperationException {
        this.resetCapability(4376);
    }

    public void setXResolution(double xresolution) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeFix32(xresolution));
        this.setCapability(4376, container);
    }

    public double[] getYResolution() throws InvalidStateException, OperationException {
        return Source.getDoubleArray(this.getCapability(1, 4377, 65535));
    }

    public double getCurrentYResolution() throws InvalidStateException, OperationException {
        return Source.getDouble(this.getCapability(2, 4377, 5));
    }

    public double getDefaultYResolution() throws InvalidStateException, OperationException {
        return Source.getDouble(this.getCapability(3, 4377, 5));
    }

    public void resetYResolution() throws InvalidStateException, OperationException {
        this.resetCapability(4377);
    }

    public void setYResolution(double Yresolution) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeFix32(Yresolution));
        this.setCapability(4377, container);
    }

    public boolean[] getAutoFeed() throws InvalidStateException, OperationException {
        return Source.getBooleanArray(this.getCapability(1, 4103, 65535));
    }

    public boolean getCurrentAutoFeed() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(2, 4103, 5));
    }

    public boolean getDefaultAutoFeed() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(3, 4103, 5));
    }

    public void resetAutoFeed() throws InvalidStateException, OperationException {
        this.resetCapability(4103);
    }

    public void setAutoFeed(boolean autoFeed) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(6, autoFeed ? 1 : 0));
        this.setCapability(4103, container);
    }

    public boolean getFeederEnabled() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4098, 5));
    }

    public boolean getCurrentFeederEnabled() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(2, 4098, 5));
    }

    public boolean getDefaultFeederEnabled() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(3, 4098, 5));
    }

    public void setFeederEnabled(boolean feederEnabled) throws InvalidStateException, OperationException {
        this.setCapability(4098, new ValueContainerOneValue(new ItemTypeInteger(6, feederEnabled ? 1 : 0)));
    }

    public boolean getFeederLoaded() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4099, 5));
    }

    public boolean getCurrentFeederLoaded() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(2, 4099, 5));
    }

    public boolean getDefaultFeederLoaded() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(3, 4099, 5));
    }

    public boolean getClearPage() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4104, 5));
    }

    public boolean getCurrentClearPage() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(2, 4104, 5));
    }

    public boolean getDefaultClearPage() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(3, 4104, 5));
    }

    public void resetClearPage() throws InvalidStateException, OperationException {
        this.resetCapability(4104);
    }

    public void setClearPage(boolean clearPage) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(6, clearPage ? 1 : 0));
        this.setCapability(4104, container);
    }

    public boolean getRewindPage() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4106, 5));
    }

    public boolean getCurrentRewindPage() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(2, 4106, 5));
    }

    public boolean getDefaultRewindPage() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(3, 4106, 5));
    }

    public void resetRewindPage() throws InvalidStateException, OperationException {
        this.resetCapability(4106);
    }

    public void setRewindPage(boolean rewindPage) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(6, rewindPage ? 1 : 0));
        this.setCapability(4106, container);
    }

    public boolean getFeedPage() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4105, 5));
    }

    public boolean getCurrentFeedPage() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(2, 4105, 5));
    }

    public boolean getDefaultFeedPage() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(3, 4105, 5));
    }

    public void resetFeedPage() throws InvalidStateException, OperationException {
        this.resetCapability(4105);
    }

    public void setFeedPage(boolean feedPage) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(6, feedPage ? 1 : 0));
        this.setCapability(4106, container);
    }

    public int[] getAlarms() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 4120, 3));
    }

    public void setAlarms(int[] alarms) throws InvalidStateException, OperationException {
        if (alarms == null || alarms.length == 0) {
            return;
        }
        ValueContainerArray array = new ValueContainerArray();
        int i = 0;
        while (i < alarms.length) {
            array.pushItem(new ItemTypeInteger(4, alarms[i]));
            ++i;
        }
        this.setCapability(4120, array);
    }

    public int[] getAlarmVolume() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 4121, 65535));
    }

    public int getCurrentAlarmVolume() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(2, 4121, 5));
    }

    public boolean getAutomaticBorderDetection() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4432, 5));
    }

    public boolean getCurrentAutomaticBorderDetection() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(2, 4432, 5));
    }

    public boolean getDefaultAutomaticBorderDetection() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(3, 4432, 5));
    }

    public void setAutomaticBorderDetection(boolean enabled) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(6, enabled ? 1 : 0));
        this.setCapability(4432, container);
    }

    public void resetAutomaticBorderDetection() throws InvalidStateException, OperationException {
        this.resetCapability(4432);
    }

    public boolean getAutomaticDeskew() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4433, 5));
    }

    public boolean getCurrentAutomaticDeskew() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(2, 4433, 5));
    }

    public boolean getDefaultAutomaticDeskew() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(3, 4433, 5));
    }

    public void setAutomaticDeskew(boolean enabled) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(6, enabled ? 1 : 0));
        this.setCapability(4433, container);
    }

    public void resetAutomaticDeskew() throws InvalidStateException, OperationException {
        this.resetCapability(4433);
    }

    public boolean getAutomaticRotate() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4434, 5));
    }

    public boolean getCurrentAutomaticRotate() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(2, 4434, 5));
    }

    public boolean getDefaultAutomaticRotate() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(3, 4434, 5));
    }

    public void setAutomaticRotate(boolean enabled) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(6, enabled ? 1 : 0));
        this.setCapability(4434, container);
    }

    public void resetAutomaticRotate() throws InvalidStateException, OperationException {
        this.resetCapability(4434);
    }

    public int getFlipRotation() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(1, 4406, 5));
    }

    public int getCurrentFlipRotation() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(2, 4406, 5));
    }

    public int getDefaultFlipRotation() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(3, 4406, 5));
    }

    public void setFlipRotation(int flipRotation) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(4, flipRotation));
        this.setCapability(4406, container);
    }

    public void resetFlipRotation() throws InvalidStateException, OperationException {
        this.resetCapability(4406);
    }

    public int getAutomaticCapture() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(1, 4122, 5));
    }

    public int getCurrentAutomaticCapture() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(2, 4122, 5));
    }

    public int getDefaultAutomaticCapture() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(3, 4122, 5));
    }

    public void setAutomaticCapture(int numberOfImages) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(2, numberOfImages));
        this.setCapability(4122, container);
    }

    public void resetAutomaticCapture(int numberOfImages) throws InvalidStateException, OperationException {
        this.resetCapability(7);
    }

    public boolean getAutoScan() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4112, 5));
    }

    public void setAutoScan(boolean autoScan) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(6, autoScan ? 1 : 0));
        this.setCapability(4112, container);
    }

    public boolean getBarCodeDetectionEnabled() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4407, 5));
    }

    public void setBarCodeDetectionEnabled(boolean enableBarCodeDetection) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(6, enableBarCodeDetection ? 1 : 0));
        this.setCapability(4407, container);
    }

    public int[] getExtendedCapabilities() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 4102, 3));
    }

    public String[] getExtendedCapabilitiessStrings() throws InvalidStateException, OperationException {
        Long[] values = (Long[])this.getCapability(1, 4102, 3);
        if (values == null) {
            return null;
        }
        String[] strings = new String[values.length];
        int i = 0;
        while (i < strings.length) {
            strings[i] = Capability.getCapabilityString(values[i].intValue());
            ++i;
        }
        return strings;
    }

    public void setExtendedCapabilities(int[] extendedCaps) throws InvalidStateException, OperationException {
        ValueContainerArray array = new ValueContainerArray();
        int i = 0;
        while (i < extendedCaps.length) {
            array.pushItem(new ItemTypeInteger(4, extendedCaps[i]));
            ++i;
        }
        this.setCapability(4102, array);
    }

    public double getGamma() throws InvalidStateException, OperationException {
        return Source.getDouble(this.getCapability(1, 4360, 5));
    }

    public void setGamma(double gamma) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeFix32(gamma));
        this.setCapability(4360, container);
    }

    public boolean getDeviceOnline() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4111, 5));
    }

    public String getDeviceDateTime() throws InvalidStateException, OperationException {
        return this.getCapability(1, 4127, 5).toString();
    }

    public String getAuthor() throws InvalidStateException, OperationException {
        return this.getCapability(1, 4096, 5).toString();
    }

    public void setAuthor(String author) throws InvalidStateException, OperationException {
        this.setCapability(4096, new ValueContainerOneValue(new ItemTypeString(11, author)));
    }

    public String getCaption() throws InvalidStateException, OperationException {
        return this.getCapability(1, 4097, 5).toString();
    }

    public void setCaption(String caption) throws InvalidStateException, OperationException {
        this.setCapability(4096, new ValueContainerOneValue(new ItemTypeString(12, caption)));
    }

    public void setPrinterString(String string) throws InvalidStateException, OperationException {
        this.setCapability(4138, new ValueContainerOneValue(new ItemTypeString(12, string)));
    }

    public String getPrinterString() throws InvalidStateException, OperationException {
        try {
            return this.getCapability(1, 4138, 5).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.getCapability(1, 4138, 4).toString();
        }
    }

    public boolean getAutoBright() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4352, 5));
    }

    public void setAutoBright(boolean enableAutoBright) throws InvalidStateException, OperationException {
        this.setCapability(4352, new ValueContainerOneValue(new ItemTypeInteger(6, enableAutoBright ? 1 : 0)));
    }

    public boolean getIndicators() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4107, 5));
    }

    public void setIndicators(boolean useProgressIndicator) throws InvalidStateException, OperationException {
        this.setCapability(4107, new ValueContainerOneValue(new ItemTypeInteger(6, useProgressIndicator ? 1 : 0)));
    }

    public int getClearBuffers() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(1, 4125, 5));
    }

    public void setClearBuffers(int option) throws InvalidStateException, OperationException {
        this.setCapability(4107, new ValueContainerOneValue(new ItemTypeInteger(4, option)));
    }

    public int[] getMaxBatchBuffers() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 4126, -1));
    }

    public void setMaxBatchBuffers(int size) throws InvalidStateException, OperationException {
        this.setCapability(4126, new ValueContainerOneValue(new ItemTypeInteger(5, size)));
    }

    public double[] getBrightness() throws InvalidStateException, OperationException {
        return Source.getDoubleArray(this.getCapability(1, 4353, -1));
    }

    public void setBrightness(double[] values) throws InvalidStateException, OperationException {
        if (values == null) {
            throw new IllegalArgumentException("Array values is null.");
        }
        if (values.length == 1) {
            this.setCapability(4353, new ValueContainerOneValue(new ItemTypeFix32(values[0])));
        } else {
            ValueContainerArray array = new ValueContainerArray();
            int i = 0;
            while (i < values.length) {
                array.pushItem(new ItemTypeFix32(values[i]));
                ++i;
            }
            this.setCapability(4353, array);
        }
    }

    public double[] getContrast() throws InvalidStateException, OperationException {
        return Source.getDoubleArray(this.getCapability(1, 4355, -1));
    }

    public void setContrast(double[] values) throws InvalidStateException, OperationException {
        if (values == null) {
            throw new IllegalArgumentException("Array values is null.");
        }
        if (values.length == 1) {
            this.setCapability(4355, new ValueContainerOneValue(new ItemTypeFix32(values[0])));
        } else {
            ValueContainerArray array = new ValueContainerArray();
            int i = 0;
            while (i < values.length) {
                array.pushItem(new ItemTypeFix32(values[i]));
                ++i;
            }
            this.setCapability(4355, array);
        }
    }

    public int[] getPrinter() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 4134, 65535));
    }

    public void setPrinter(int printer) throws InvalidStateException, OperationException {
        this.setCapability(4134, new ValueContainerOneValue(new ItemTypeInteger(4, printer)));
    }

    public boolean getPrinterEnabled() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4135, -1));
    }

    public void setPrinterEnabled(boolean enable) throws InvalidStateException, OperationException {
        this.setCapability(4135, new ValueContainerOneValue(new ItemTypeInteger(6, enable ? 1 : 0)));
    }

    public int getPrinterMode() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(1, 4137, 65535));
    }

    public double[][] getFrames() throws InvalidStateException, OperationException {
        Object value = this.getCapability(1, 4372, -1);
        if (value instanceof Double[]) {
            return new double[][]{Source.getDoubleArray(value)};
        }
        if (value instanceof Double[][]) {
            Double[][] doubleMatrix = (Double[][])value;
            double[][] ret = new double[doubleMatrix.length][];
            int i = 0;
            while (i < ret.length) {
                ret[i] = Source.getDoubleArray(doubleMatrix[i]);
                ++i;
            }
            return ret;
        }
        throw new OperationException("Unexpected return value: " + value);
    }

    public double[] getCurrentFrame() throws InvalidStateException, OperationException {
        return Source.getDoubleArray(this.getCapability(1, 4372, -1));
    }

    public void setFrames(double[][] multipleFrames) throws InvalidStateException, OperationException {
        if (multipleFrames == null) {
            throw new IllegalArgumentException("Argument is null. ");
        }
        if (multipleFrames.length == 1) {
            this.setCapability(4372, new ValueContainerOneValue(new ItemTypeFrame(multipleFrames[0][0], multipleFrames[0][1], multipleFrames[0][2], multipleFrames[0][3])));
        } else {
            ValueContainerArray array = new ValueContainerArray();
            int i = 0;
            while (i < multipleFrames.length) {
                array.pushItem(new ItemTypeFrame(multipleFrames[i][0], multipleFrames[i][1], multipleFrames[i][2], multipleFrames[i][3]));
                ++i;
            }
            this.setCapability(4372, array);
        }
    }

    public void setFrames(double[] singleFrame) throws InvalidStateException, OperationException {
        if (singleFrame == null) {
            throw new IllegalArgumentException("Argument is null. ");
        }
        this.setFrames(new double[][]{singleFrame});
    }

    public int getMaxFrames() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(1, 4378, -1));
    }

    public void setMaxFrames(int max) throws InvalidStateException, OperationException {
        this.setCapability(4135, new ValueContainerOneValue(new ItemTypeInteger(4, max)));
    }

    public int[] getSupportedSizes() throws InvalidStateException, OperationException {
        return Source.getIntArray(this.getCapability(1, 4386, -1));
    }

    public void setSupportedSizes(int[] sizes) throws InvalidStateException, OperationException {
        ValueContainerArray array = new ValueContainerArray();
        int i = 0;
        while (i < sizes.length) {
            array.pushItem(new ItemTypeInteger(4, sizes[i]));
            ++i;
        }
        this.setCapability(4386, array);
    }

    public boolean getPatchCodeDetectionEnabled() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4415, -1));
    }

    public void setPatchCodeDetectionEnabled(boolean enable) throws InvalidStateException, OperationException {
        this.setCapability(4386, new ValueContainerOneValue(new ItemTypeInteger(6, enable ? 1 : 0)));
    }

    public void setDuplexEnabled(boolean enable) throws InvalidStateException, OperationException {
        ValueContainerOneValue container = new ValueContainerOneValue(new ItemTypeInteger(6, enable ? 1 : 0));
        this.setCapability(4115, container);
    }

    public boolean getDuplexEnabled() throws InvalidStateException, OperationException {
        return Source.getBoolean(this.getCapability(1, 4115, 5));
    }

    public int getDuplex() throws InvalidStateException, OperationException {
        return Source.getInt(this.getCapability(1, 4114, -1));
    }

    public static boolean getBoolean(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Long) {
            return ((Long)o).intValue() != 0;
        }
        return false;
    }

    public static boolean[] getBooleanArray(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return new boolean[]{((Long)o).intValue() != 0};
        }
        if (o instanceof Long[]) {
            Long[] longs = (Long[])o;
            boolean[] bools = new boolean[longs.length];
            int i = 0;
            while (i < bools.length) {
                bools[i] = longs[i].intValue() != 0;
                ++i;
            }
            return bools;
        }
        return null;
    }

    public static int getInt(Object o) {
        if (o == null) {
            return -999;
        }
        if (o instanceof Long) {
            return ((Long)o).intValue();
        }
        return -999;
    }

    public static int[] getIntArray(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return new int[]{((Long)o).intValue()};
        }
        if (o instanceof Long[]) {
            Long[] longs = (Long[])o;
            int[] ints = new int[longs.length];
            int i = 0;
            while (i < ints.length) {
                ints[i] = longs[i].intValue();
                ++i;
            }
            return ints;
        }
        return null;
    }

    public static double getDouble(Object o) {
        if (o == null) {
            return -999.0;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        return -999.0;
    }

    public static double[] getDoubleArray(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return new double[]{((Long)o).intValue()};
        }
        if (o instanceof Double[]) {
            Double[] doubles = (Double[])o;
            double[] ds = new double[doubles.length];
            int i = 0;
            while (i < ds.length) {
                ds[i] = doubles[i];
                ++i;
            }
            return ds;
        }
        return null;
    }

    public Object getCapability(int mesgType, int capabilityCode, int expectedContainerType) throws InvalidStateException, OperationException {
        Control.assertState(this, 4);
        Capability capability = new Capability(capabilityCode);
        OperationResult result = Control.CapabilityMsg(mesgType, capability);
        if (result == null && this.exceptionLevel > 0) {
            throw new OperationException("Operation failed.");
        }
        if (!(result.isSuccessful() && result.getContainer() != null || this.exceptionLevel <= 0)) {
            throw new OperationException("Operation failed: " + result);
        }
        if (result == null || result.getContainer() == null) {
            return null;
        }
        int containerType = result.getContainer().getContainerType();
        if (expectedContainerType != 65535 && expectedContainerType != -1 && expectedContainerType != 255 && containerType != expectedContainerType) {
            throw new OperationException("Operation failed: Unexpected container type. Expected: " + expectedContainerType + ", actual: " + containerType + " for cap " + capabilityCode);
        }
        return result.getContainer().getObject();
    }

    public void resetCapability(int capabilityCode) throws InvalidStateException, OperationException {
        Control.assertState(this, 4);
        Capability capability = new Capability(capabilityCode);
        OperationResult result = Control.CapabilityMsgReset(capability);
        if (result == null && this.exceptionLevel > 0) {
            throw new OperationException("Operation failed.");
        }
        if (!result.isSuccessful() && this.exceptionLevel > 0) {
            throw new OperationException("Operation failed: " + result);
        }
    }

    public void setCapability(int capabilityCode, ValueContainer container) throws InvalidStateException, OperationException {
        Control.assertState(this, 4);
        Capability capability = new Capability(capabilityCode);
        capability.setContainer(container);
        OperationResult result = Control.CapabilityMsgSet(capability);
        if (result == null && this.exceptionLevel > 0) {
            throw new OperationException("Operation failed.");
        }
        if (!result.isSuccessful() && this.exceptionLevel > 0) {
            throw new OperationException("Operation failed: " + result);
        }
    }
}

