/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.jtwain;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

class ImageGenerator
implements ImageConsumer {
    private Object holder = new Object();
    private ColorModel colorModel;
    private Hashtable properties;
    private WritableRaster raster;
    private int width = -1;
    private int height = -1;
    private BufferedImage image;
    private int[] intBuffer;
    private boolean loadComplete = false;

    ImageGenerator() {
    }

    public void imageComplete(int status) {
        if (status == 3 || status == 4 || status == 1) {
            Object object = this.holder;
            synchronized (object) {
                this.loadComplete = true;
                this.holder.notify();
            }
        } else {
            System.err.println("Some other value passed to complete");
        }
    }

    public void setColorModel(ColorModel model) {
        this.colorModel = model;
        this.createImage();
    }

    public void setDimensions(int w, int h) {
        this.width = w;
        this.height = h;
        this.createImage();
    }

    public void setHints(int flags) {
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        if (this.loadComplete) {
            return;
        }
        if (this.intBuffer == null || pixels.length > this.intBuffer.length) {
            this.intBuffer = new int[pixels.length];
        }
        int i = pixels.length;
        while (--i >= 0) {
            this.intBuffer[i] = pixels[i] & 0xFF;
        }
        this.raster.setPixels(x, y, w, h, this.intBuffer);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        if (this.loadComplete) {
            return;
        }
        this.image.setRGB(x, y, w, h, pixels, offset, scansize);
    }

    public void setProperties(Hashtable props) {
        this.properties = props;
        this.createImage();
    }

    BufferedImage getImage() {
        if (!this.loadComplete) {
            Object object = this.holder;
            synchronized (object) {
                try {
                    this.holder.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.image;
    }

    void reset() {
        Object object = this.holder;
        synchronized (object) {
            this.holder.notify();
        }
        this.loadComplete = false;
        this.colorModel = null;
        this.raster = null;
        this.properties = null;
        this.image = null;
        this.width = -1;
        this.height = -1;
    }

    private void createImage() {
        if (this.image != null || this.width == -1 || this.colorModel == null || this.loadComplete) {
            return;
        }
        this.raster = this.colorModel.createCompatibleWritableRaster(this.width, this.height);
        boolean premult = this.colorModel.isAlphaPremultiplied();
        this.image = new BufferedImage(this.colorModel, this.raster, premult, this.properties);
    }

    static BufferedImage createBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        ImageProducer prod = img.getSource();
        ImageGenerator gen = new ImageGenerator();
        prod.startProduction(gen);
        return gen.getImage();
    }
}

