/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.UIManager;

public class JTwainDemoLauncher {
    boolean packFrame = false;
    JTwainDemoLauncherFrame frame;
    String demoJar;
    MessageListener messageListener = new MessageListener();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JTwainDemoLauncher(String demoJar) {
        this.demoJar = demoJar;
        this.frame = new JTwainDemoLauncherFrame(this);
        if (this.packFrame) {
            this.frame.pack();
        } else {
            this.frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.frame.setVisible(true);
        this.frame.jMenuHelpAbout_actionPerformed(null);
        this.loadClasses(demoJar);
    }

    public void loadClasses(String fileName) {
        File file = null;
        try {
            file = new File(fileName);
            if (!file.exists()) {
                this.messageListener.error("The Jar file specified does not exist: " + file.toString());
            }
        }
        catch (Exception e) {
            this.messageListener.exception(e);
        }
        if (file == null) {
            this.loadClasses((JarFile)null);
        } else {
            try {
                this.loadClasses(new JarFile(file));
            }
            catch (IOException e1) {
                this.messageListener.exception(e1);
            }
        }
    }

    public void loadClasses(JarFile jarFile) {
        JTwainDemoCode.setOutputListener(this.messageListener);
        if (jarFile == null) {
            this.frame.text.append("Jar file not found!");
            return;
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            name = name.substring(0, name.length() - 6);
            try {
                Class<?> cls = Class.forName(name);
                Class<?> clazz = cls.getSuperclass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("JTwainDemoCode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.equals(clazz2)) continue;
                this.frame.classes.addItem(name);
            }
            catch (Throwable t) {
                this.messageListener.exception(t);
            }
        }
        this.frame.classes.setSelectedItem("TestJTwain");
    }

    public void invokeClass(String className) {
        this.frame.text.setText("Executing " + className + " ... \n");
        try {
            JTwainDemoLauncher.invokeMainMethod(className, null);
        }
        catch (Throwable t) {
            this.messageListener.exception(t);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (args != null && args.length >= 1) {
            new JTwainDemoLauncher(args[0]);
        } else {
            new JTwainDemoLauncher(null);
        }
    }

    public static void invokeMainMethod(String targetClass, String[] arguments) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] paramTypes = new Class[]{Class.forName("[Ljava.lang.String;")};
        Method main = Class.forName(targetClass).getMethod("main", paramTypes);
        if ((main.getModifiers() & 8) == 0) {
            throw new NoSuchMethodException("The main method in target class is not static.");
        }
        if (main.getReturnType() != Void.TYPE) {
            throw new NoSuchMethodException("The return type of the main method in target class is not void.");
        }
        main.invoke(null, new Object[]{arguments});
    }

    class MessageListener
    extends JTwainDemoCode.OutputListener {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(this.stringWriter);

        MessageListener() {
        }

        public void error(String error) {
            JTwainDemoLauncher.this.frame.text.append(String.valueOf(error) + "\n");
        }

        public void exception(Throwable e) {
            this.stringWriter.getBuffer().setLength(0);
            e.printStackTrace(this.printWriter);
            this.printWriter.flush();
            this.stringWriter.flush();
            JTwainDemoLauncher.this.frame.text.append(String.valueOf(this.stringWriter.getBuffer().toString()) + "\n");
        }

        public void message(String message) {
            JTwainDemoLauncher.this.frame.text.append(String.valueOf(message) + "\n");
        }
    }
}

