/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.ScrollPane;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class ImageDisplayer
extends Component {
    private Image image;
    private String title;
    private Frame frame;
    WindowListener listener = new WindowAdapter(){

        public void windowClosing(WindowEvent e) {
            ImageDisplayer.this.frame.dispose();
        }
    };

    public ImageDisplayer(Image image) {
        this.image = image;
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.image, 1);
        try {
            tracker.waitForAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.frame = new Frame();
        this.frame.addWindowListener(this.listener);
        ScrollPane scroller = new ScrollPane(0);
        scroller.add(this);
        scroller.setBackground(Color.lightGray);
        this.frame.add("Center", scroller);
        if (image != null) {
            this.frame.setSize(new Dimension(image.getWidth(null) + 30, image.getHeight(null) + 40));
        }
        if (this.frame.getHeight() < 600 || this.frame.getWidth() < 400) {
            this.frame.setSize(new Dimension(400, 600));
        }
        this.frame.setVisible(true);
        this.frame.toFront();
    }

    public Frame getFrame() {
        return this.frame;
    }

    public ImageDisplayer(String title, Image image) {
        this(image);
        this.setTitle(title);
    }

    public Dimension getPreferredSize() {
        if (this.image == null || this.image.getHeight(null) <= 0) {
            return new Dimension(300, 300);
        }
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }

    public void paint(Graphics g) {
        g.setColor(Color.black);
        if (this.image != null && this.image.getHeight(null) > 0) {
            g.drawImage(this.image, 0, 0, this);
        } else {
            g.drawString("Oops! NO IMAGE LOADED. ", 20, 20);
        }
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.frame != null && title != null) {
            this.frame.setTitle(title);
        }
    }
}

