/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.ocr.sample.util;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class LinkLabel
extends JLabel {
    private static final long serialVersionUID = 8273875024682878518L;
    private String text;
    private URI uri;

    public LinkLabel() {
    }

    public LinkLabel(String text, URI uri) {
        this.setup(text, uri);
    }

    public LinkLabel(String text, String uri) {
        URI oURI;
        try {
            oURI = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.setup(text, oURI);
    }

    public void setup(String t, URI u) {
        this.text = t;
        this.uri = u;
        this.setText(this.text);
        this.setToolTipText(this.uri.toString());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LinkLabel.open(LinkLabel.this.uri);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LinkLabel.this.setText(LinkLabel.this.text, false);
                LinkLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkLabel.this.setText(LinkLabel.this.text, true);
                LinkLabel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    @Override
    public void setText(String text) {
        this.setText(text, true);
    }

    public void setText(String text, boolean ul) {
        String link = ul ? "<u>" + text + "</u>" : text;
        super.setText("<html><span style=\"color: #000099;\">" + link + "</span></html>");
        this.text = text;
    }

    public String getRawText() {
        return this.text;
    }

    private static void open(URI uri) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uri);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "URL: " + uri, "Please use your browser to visit:", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "URL: " + uri, "Please use your browser to visit:", 2);
        }
    }
}

