/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.ocr.sample.util;

import com.asprise.ocr.sample.util.RoundedBorder;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class JPanelGradient
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected Color bgGradient1;
    protected Color bgGradient2;
    protected RoundedBorder border;
    AdditionalPaint additionalPaint;

    public JPanelGradient() {
        this(10, Color.lightGray, Color.white, new Color(0xE8E8E8));
    }

    public JPanelGradient(int borderCornerRadius, Color borderColor, Color bgGradient1, Color bgGradient2) {
        this.setBackgroundGradient(bgGradient1, bgGradient2);
        this.border = new RoundedBorder(borderCornerRadius, borderColor);
        this.setBorder(this.border);
    }

    public void setBorderCornerRadius(int borderCornerRadius) {
        this.border.setCornerRadius(borderCornerRadius);
        this.repaint();
    }

    public void setBorderColor(Color borderColor) {
        this.border.setColor(borderColor);
        this.repaint();
    }

    public void setBackgroundGradient(Color color1, Color color2) {
        this.bgGradient1 = color1;
        this.bgGradient2 = color2;
    }

    public void setBackgroundGradientColor1(Color color) {
        this.bgGradient1 = color;
    }

    public void setBackgroundGradientColor2(Color color) {
        this.bgGradient2 = color;
    }

    public AdditionalPaint getAdditionalPaint() {
        return this.additionalPaint;
    }

    public void setAdditionalPaint(AdditionalPaint additionalPaint) {
        this.additionalPaint = additionalPaint;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            return;
        }
        if (this.bgGradient1 == null || this.bgGradient2 == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.bgGradient1, 0.0f, h, this.bgGradient2, false);
        g2.setPaint(gradient);
        g2.fillRoundRect(0, 0, w, h, this.border.getCornerRadius(), this.border.getCornerRadius());
        if (this.additionalPaint != null) {
            this.additionalPaint.additionalPaint(g2, w, h);
        }
    }

    public static interface AdditionalPaint {
        public void additionalPaint(Graphics2D var1, int var2, int var3);
    }
}

